namespace win
  #define WIN_INCLUDEALL
  #include "windows.bi"
  #include "win\commctrl.bi"
end namespace
using win

#include "resource.bi"
'' simply comment this line if you get collisions... wasn't defined in my
'' headers
const GPTR = (GMEM_FIXED Or GMEM_ZEROINIT)

declare function WinMain ( _
  byval hInstance as win.hInstance, _
  byval hPrevInstance as win.hInstance, _
  byval lpCmdLine as win.LPSTR, _
  byval nCmdShow as integer ) as integer
end WinMain( win.GetModuleHandle( NULL ), NULL, command, SW_NORMAL )

const as string g_szClassName = "myWindowClass"
const as string g_szChildClassName = "myMDIChildWindowClass"

#define IDC_MAIN_MDI	101
#define IDC_MAIN_TOOL	102
#define IDC_MAIN_STATUS	103

#define IDC_CHILD_EDIT	101

#define ID_MDI_FIRSTCHILD 50000

dim shared as win.HWND g_hMDIClient = NULL
dim shared as win.HWND g_hMainWindow = NULL

function LoadTextFileToEdit( _
	byval hEdit as win.HWND, _
	byval pszFileName as win.LPCTSTR ) as win.BOOL
	
	dim as win.HANDLE hFile
	dim as win.BOOL bSuccess = FALSE

	hFile = win.CreateFile(pszFileName, GENERIC_READ, FILE_SHARE_READ, NULL, _
		OPEN_EXISTING, 0, NULL)
		
	if(hFile <> INVALID_HANDLE_VALUE) then
		dim as win.DWORD dwFileSize

		dwFileSize = win.GetFileSize(hFile, NULL)
		if(dwFileSize <> &hFFFFFFFF) then
			dim as win.LPSTR pszFileText

			pszFileText = win.GlobalAlloc(GPTR, dwFileSize + 1)
			if(pszFileText <> NULL) then
				dim as win.DWORD dwRead

				if(win.ReadFile(hFile, pszFileText, dwFileSize, @dwRead, NULL)) then
				
					pszFileText[dwFileSize] = 0 '' Add null terminator
					if(win.SetWindowText(hEdit, pszFileText)) then
						bSuccess = TRUE '' It worked!
					end if
					
				end if
				
				win.GlobalFree(pszFileText)
			end if
			
		end if
		win.CloseHandle(hFile)
	end if
	
	return bSuccess
end function

function SaveTextFileFromEdit( _
	byval hEdit as win.HWND, _
	byval pszFileName as win.LPCTSTR ) as win.BOOL
	
	dim as win.HANDLE hFile
	dim as win.BOOL bSuccess = FALSE

	hFile = win.CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, _
		CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL)
	if(hFile <> INVALID_HANDLE_VALUE) then
	
		dim as win.DWORD dwTextLength

		dwTextLength = win.GetWindowTextLength(hEdit)
		'' No need to bother if there's no text.
		if(dwTextLength > 0) then
		
			dim as win.LPSTR pszText
			dim as win.DWORD dwBufferSize = dwTextLength + 1

			pszText = win.GlobalAlloc(GPTR, dwBufferSize)
			if(pszText <> NULL) then
			
				if(win.GetWindowText(hEdit, pszText, dwBufferSize)) then
				
					dim as win.DWORD dwWritten

					if(win.WriteFile(hFile, pszText, dwTextLength, @dwWritten, NULL)) then
						bSuccess = TRUE
					end if
					
				end if
				win.GlobalFree(pszText)
			end if
		end if
		win.CloseHandle(hFile)
	end if
	return bSuccess
end function

sub DoFileOpen( byval hwnd as win.HWND )
	
	'' possible errors from
	'' here ---->
	dim as win.OPENFILENAME ofn
	dim as zstring * MAX_PATH szFileName

	win.ZeroMemory(@ofn, sizeof(ofn))

	ofn.lStructSize = sizeof(ofn)
	ofn.hwndOwner = hwnd
	ofn.lpstrFilter = strptr(!"Text Files (*.txt)\0*.txt\0All Files (*.*)\0*.*\0")
	ofn.lpstrFile = strptr(szFileName)
	ofn.nMaxFile = MAX_PATH
	ofn.Flags = OFN_EXPLORER or OFN_FILEMUSTEXIST or OFN_HIDEREADONLY
	ofn.lpstrDefExt = strptr("txt")
	'' <---- to here

	if(win.GetOpenFileName(@ofn)) then
		dim as win.HWND hEdit = win.GetDlgItem(hwnd, IDC_CHILD_EDIT)
		if(LoadTextFileToEdit(hEdit, szFileName)) then
			win.SendDlgItemMessage(g_hMainWindow, IDC_MAIN_STATUS, SB_SETTEXT, 0, cast( win.LPARAM, strptr("Opened...")) )
			win.SendDlgItemMessage(g_hMainWindow, IDC_MAIN_STATUS, SB_SETTEXT, 1, cast( win.LPARAM, @szFileName) )

			win.SetWindowText(hwnd, szFileName)
		end if
	end if
end sub

sub DoFileSave( byval hwnd as win.HWND )

	'' possible errors from
	'' here ---->
	dim as win.OPENFILENAME ofn
	dim as zstring * MAX_PATH szFileName

	win.ZeroMemory(@ofn, sizeof(ofn))

	ofn.lStructSize = sizeof(ofn)
	ofn.hwndOwner = hwnd
	ofn.lpstrFilter = strptr(!"Text Files (*.txt)\0*.txt\0All Files (*.*)\0*.*\0")
	ofn.lpstrFile = strptr(szFileName)
	ofn.nMaxFile = MAX_PATH
	ofn.lpstrDefExt = strptr("txt")
	ofn.Flags = OFN_EXPLORER or OFN_PATHMUSTEXIST or OFN_HIDEREADONLY or OFN_OVERWRITEPROMPT
	'' <---- to here

	if(win.GetSaveFileName(@ofn)) then
	
		dim as win.HWND hEdit = GetDlgItem(hwnd, IDC_CHILD_EDIT)
		if(SaveTextFileFromEdit(hEdit, szFileName)) then
		
			win.SendDlgItemMessage(g_hMainWindow, IDC_MAIN_STATUS, SB_SETTEXT, 0, cast( win.LPARAM, strptr("Saved...") ))
			win.SendDlgItemMessage(g_hMainWindow, IDC_MAIN_STATUS, SB_SETTEXT, 1, cast( win.LPARAM, @szFileName ))

			win.SetWindowText(hwnd, szFileName)
		end if
	end if
end sub

function CreateNewMDIChild(byval hMDIClient as win.HWND) as win.HWND

	dim as win.MDICREATESTRUCT mcs
	dim as win.HWND hChild

	mcs.szTitle = strptr("[Untitled]")
	mcs.szClass = strptr(g_szChildClassName)
	mcs.hOwner  = GetModuleHandle(NULL)
	mcs.x = mcs.cx = CW_USEDEFAULT
	mcs.y = mcs.cy = CW_USEDEFAULT
	mcs.style = MDIS_ALLCHILDSTYLES

	hChild = cast( win.HWND, win.SendMessage(hMDIClient, WM_MDICREATE, 0, cast( LONG, @mcs) ) )
	if(not hChild) then
		win.MessageBox(hMDIClient, strptr("MDI Child creation failed."), strptr("Oh Oh..."), _
			MB_ICONEXCLAMATION or MB_OK)
	end if
	return hChild
end function

function WndProc( _
  byval hwnd as win.HWND, _
  byval msg as win.UINT, _
  byval wParam as win.WPARAM, _
  byval lParam as win.LPARAM) as win.LRESULT
  
	select case msg
		case WM_CREATE:
		scope
			dim as win.HWND hTool
			dim as win.TBBUTTON tbb(3)
			dim as win.TBADDBITMAP tbab

			dim as win.HWND hStatus
			dim as integer statwidths(0 to 1) => {100, -1}

			dim as win.CLIENTCREATESTRUCT ccs

			'' Create MDI Client

			'' Find window menu where children will be listed
			ccs.hWindowMenu  = GetSubMenu(GetMenu(hwnd), 2)
			ccs.idFirstChild = ID_MDI_FIRSTCHILD

			g_hMDIClient = CreateWindowEx(WS_EX_CLIENTEDGE, "mdiclient", NULL,
				WS_CHILD | WS_CLIPCHILDREN | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE,
				CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
				hwnd, (HMENU)IDC_MAIN_MDI, GetModuleHandle(NULL), (LPVOID)&ccs)

			if(g_hMDIClient == NULL)
				MessageBox(hwnd, "Could not create MDI client.", "Error", MB_OK | MB_ICONERROR)

			'' Create Toolbar

			hTool = CreateWindowEx(0, TOOLBARCLASSNAME, NULL, WS_CHILD | WS_VISIBLE, 0, 0, 0, 0,
				hwnd, (HMENU)IDC_MAIN_TOOL, GetModuleHandle(NULL), NULL)
			if(hTool == NULL)
				MessageBox(hwnd, "Could not create tool bar.", "Error", MB_OK | MB_ICONERROR)

			'' Send the TB_BUTTONSTRUCTSIZE message, which is required for
			'' backward compatibility.
			SendMessage(hTool, TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0)
			
			tbab.hInst = HINST_COMMCTRL
			tbab.nID = IDB_STD_SMALL_COLOR
			SendMessage(hTool, TB_ADDBITMAP, 0, (LPARAM)&tbab)

			ZeroMemory(tbb, sizeof(tbb))
			tbb[0].iBitmap = STD_FILENEW
			tbb[0].fsState = TBSTATE_ENABLED
			tbb[0].fsStyle = TBSTYLE_BUTTON
			tbb[0].idCommand = ID_FILE_NEW

			tbb[1].iBitmap = STD_FILEOPEN
			tbb[1].fsState = TBSTATE_ENABLED
			tbb[1].fsStyle = TBSTYLE_BUTTON
			tbb[1].idCommand = ID_FILE_OPEN

			tbb[2].iBitmap = STD_FILESAVE
			tbb[2].fsState = TBSTATE_ENABLED
			tbb[2].fsStyle = TBSTYLE_BUTTON
			tbb[2].idCommand = ID_FILE_SAVEAS

			SendMessage(hTool, TB_ADDBUTTONS, sizeof(tbb)/sizeof(TBBUTTON), (LPARAM)&tbb)

			'' Create Status bar

			hStatus = CreateWindowEx(0, STATUSCLASSNAME, NULL,
				WS_CHILD | WS_VISIBLE | SBARS_SIZEGRIP, 0, 0, 0, 0,
				hwnd, (HMENU)IDC_MAIN_STATUS, GetModuleHandle(NULL), NULL)

			SendMessage(hStatus, SB_SETPARTS, sizeof(statwidths)/sizeof(int), (LPARAM)statwidths)
			SendMessage(hStatus, SB_SETTEXT, 0, (LPARAM)"Hi there :)")
		}
		break
		case WM_SIZE:
		{
			HWND hTool
			RECT rcTool
			int iToolHeight

			HWND hStatus
			RECT rcStatus
			int iStatusHeight

			HWND hMDI
			int iMDIHeight
			RECT rcClient

			'' Size toolbar and get height

			hTool = GetDlgItem(hwnd, IDC_MAIN_TOOL)
			SendMessage(hTool, TB_AUTOSIZE, 0, 0)

			GetWindowRect(hTool, &rcTool)
			iToolHeight = rcTool.bottom - rcTool.top

			'' Size status bar and get height

			hStatus = GetDlgItem(hwnd, IDC_MAIN_STATUS)
			SendMessage(hStatus, WM_SIZE, 0, 0)

			GetWindowRect(hStatus, &rcStatus)
			iStatusHeight = rcStatus.bottom - rcStatus.top

			'' Calculate remaining height and size edit

			GetClientRect(hwnd, &rcClient)

			iMDIHeight = rcClient.bottom - iToolHeight - iStatusHeight

			hMDI = GetDlgItem(hwnd, IDC_MAIN_MDI)
			SetWindowPos(hMDI, NULL, 0, iToolHeight, rcClient.right, iMDIHeight, SWP_NOZORDER)
		}
		break
		case WM_CLOSE:
			DestroyWindow(hwnd)
		break
		case WM_DESTROY:
			PostQuitMessage(0)
		break
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case ID_FILE_EXIT:
					PostMessage(hwnd, WM_CLOSE, 0, 0)
				break
				case ID_FILE_NEW:
					CreateNewMDIChild(g_hMDIClient)
				break
				case ID_FILE_OPEN:
				{
					HWND hChild = CreateNewMDIChild(g_hMDIClient)
					if(hChild)
					{
						DoFileOpen(hChild)	
					}
				}
				break
				case ID_FILE_CLOSE:
				{
					HWND hChild = (HWND)SendMessage(g_hMDIClient, WM_MDIGETACTIVE,0,0)
					if(hChild)
					{
						SendMessage(hChild, WM_CLOSE, 0, 0)
					}
				}
				break
				case ID_WINDOW_TILE:
					SendMessage(g_hMDIClient, WM_MDITILE, 0, 0)
				break
				case ID_WINDOW_CASCADE:
					SendMessage(g_hMDIClient, WM_MDICASCADE, 0, 0)
				break
				default:
				{
					if(LOWORD(wParam) >= ID_MDI_FIRSTCHILD)
					{
						DefFrameProc(hwnd, g_hMDIClient, WM_COMMAND, wParam, lParam)
					}
					else 
					{
						HWND hChild = (HWND)SendMessage(g_hMDIClient, WM_MDIGETACTIVE,0,0)
						if(hChild)
						{
							SendMessage(hChild, WM_COMMAND, wParam, lParam)
						}
					}
				}
			}
		break
		default:
			return DefFrameProc(hwnd, g_hMDIClient, msg, wParam, lParam)
	}
	return 0
}

LRESULT CALLBACK MDIChildWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		case WM_CREATE:
		{
			HFONT hfDefault
			HWND hEdit

			'' Create Edit Control

			hEdit = CreateWindowEx(WS_EX_CLIENTEDGE, "EDIT", "", 
				WS_CHILD | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL | ES_MULTILINE | ES_AUTOVSCROLL | ES_AUTOHSCROLL, 
				0, 0, 100, 100, hwnd, (HMENU)IDC_CHILD_EDIT, GetModuleHandle(NULL), NULL)
			if(hEdit == NULL)
				MessageBox(hwnd, "Could not create edit box.", "Error", MB_OK | MB_ICONERROR)

			hfDefault = GetStockObject(DEFAULT_GUI_FONT)
			SendMessage(hEdit, WM_SETFONT, (WPARAM)hfDefault, MAKELPARAM(FALSE, 0))
		}
		break
		case WM_MDIACTIVATE:
		{
			HMENU hMenu, hFileMenu
			UINT EnableFlag

			hMenu = GetMenu(g_hMainWindow)
			if(hwnd == (HWND)lParam)
			{	   ''being activated, enable the menus
				EnableFlag = MF_ENABLED
			}
			else
			{						   ''being de-activated, gray the menus
				EnableFlag = MF_GRAYED
			}

			EnableMenuItem(hMenu, 1, MF_BYPOSITION | EnableFlag)
			EnableMenuItem(hMenu, 2, MF_BYPOSITION | EnableFlag)

			hFileMenu = GetSubMenu(hMenu, 0)
			EnableMenuItem(hFileMenu, ID_FILE_SAVEAS, MF_BYCOMMAND | EnableFlag)

			EnableMenuItem(hFileMenu, ID_FILE_CLOSE, MF_BYCOMMAND | EnableFlag)
			EnableMenuItem(hFileMenu, ID_FILE_CLOSEALL, MF_BYCOMMAND | EnableFlag)

			DrawMenuBar(g_hMainWindow)
		}
		break
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case ID_FILE_OPEN:
					DoFileOpen(hwnd)
				break
				case ID_FILE_SAVEAS:
					DoFileSave(hwnd)
				break
				case ID_EDIT_CUT:
					SendDlgItemMessage(hwnd, IDC_CHILD_EDIT, WM_CUT, 0, 0)
				break
				case ID_EDIT_COPY:
					SendDlgItemMessage(hwnd, IDC_CHILD_EDIT, WM_COPY, 0, 0)
				break
				case ID_EDIT_PASTE:
					SendDlgItemMessage(hwnd, IDC_CHILD_EDIT, WM_PASTE, 0, 0)
				break
			}
		break
		case WM_SIZE:
		{
			HWND hEdit
			RECT rcClient

			'' Calculate remaining height and size edit

			GetClientRect(hwnd, &rcClient)

			hEdit = GetDlgItem(hwnd, IDC_CHILD_EDIT)
			SetWindowPos(hEdit, NULL, 0, 0, rcClient.right, rcClient.bottom, SWP_NOZORDER)
		}
		return DefMDIChildProc(hwnd, msg, wParam, lParam)
		default:
			return DefMDIChildProc(hwnd, msg, wParam, lParam)
	
	}
	return 0
}

BOOL SetUpMDIChildWindowClass(HINSTANCE hInstance)
{
	WNDCLASSEX wc

	wc.cbSize		 = sizeof(WNDCLASSEX)
	wc.style		 = CS_HREDRAW | CS_VREDRAW
	wc.lpfnWndProc	 = MDIChildWndProc
	wc.cbClsExtra	 = 0
	wc.cbWndExtra	 = 0
	wc.hInstance	 = hInstance
	wc.hIcon		 = LoadIcon(NULL, IDI_APPLICATION)
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW)
	wc.hbrBackground = (HBRUSH)(COLOR_3DFACE+1)
	wc.lpszMenuName  = NULL
	wc.lpszClassName = g_szChildClassName
	wc.hIconSm		 = LoadIcon(NULL, IDI_APPLICATION)

	if(!RegisterClassEx(&wc))
	{
		MessageBox(0, "Could Not Register Child Window", "Oh Oh...",
			MB_ICONEXCLAMATION | MB_OK)
		return FALSE
	}
	else
		return TRUE
}


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASSEX wc
	HWND hwnd
	MSG Msg

	InitCommonControls()

	wc.cbSize		 = sizeof(WNDCLASSEX)
	wc.style		 = 0
	wc.lpfnWndProc	 = WndProc
	wc.cbClsExtra	 = 0
	wc.cbWndExtra	 = 0
	wc.hInstance	 = hInstance
	wc.hIcon		 = LoadIcon(NULL, IDI_APPLICATION)
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW)
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1)
	wc.lpszMenuName  = MAKEINTRESOURCE(IDR_MAINMENU)
	wc.lpszClassName = g_szClassName
	wc.hIconSm		 = LoadIcon(NULL, IDI_APPLICATION)

	if(!RegisterClassEx(&wc))
	{
		MessageBox(NULL, "Window Registration Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK)
		return 0
	}

	if(!SetUpMDIChildWindowClass(hInstance))
		return 0

	hwnd = CreateWindowEx(
		0,
		g_szClassName,
		"theForger's Tutorial Application",
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		CW_USEDEFAULT, CW_USEDEFAULT, 480, 320,
		NULL, NULL, hInstance, NULL)

	if(hwnd == NULL)
	{
		MessageBox(NULL, "Window Creation Failed!", "Error!",
			MB_ICONEXCLAMATION | MB_OK)
		return 0
	}

	g_hMainWindow = hwnd

	ShowWindow(hwnd, nCmdShow)
	UpdateWindow(hwnd)

	while(GetMessage(&Msg, NULL, 0, 0) > 0)
	{
		if (!TranslateMDISysAccel(g_hMDIClient, &Msg))
		{
			TranslateMessage(&Msg)
			DispatchMessage(&Msg)
		}
	}
	return Msg.wParam
}
